set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9428112';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '323',
      '24422144',
      44.787006,
      44.620070,
      NULL,
      117.053373,
      3,
      0,
      1,
      '142103',
      2,
      ' 7- 0-1975',
      35.796885,
      65,
      1.850049,
      NULL,
      2,
      2.817273,
      0.603564,
      0,
      1.274389,
      3.866614,
      NULL,
      2,
      NULL,
      1.648740,
      4.164429,
      1.859515,
      0,
      3,
      1,
      0.834840,
      6,
      NULL,
      1,
      1.056414,
      NULL,
      1,
      3.511327,
      1,
      4,
      0.665109,
      0.158172,
      0,
      NULL,
      NULL,
      0.182277,
      NULL,
      NULL,
      6.735522,
      0,
      2.356712,
      2,
      1,
      0.604572,
      0,
      0.184434,
      3.207917,
      0,
      0.561735,
      1.053362,
      0,
      1,
      1.469493,
      1,
      2,
      1,
      0,
      5,
      0.632373,
      0,
      3.163725,
      0,
      0,
      0,
      1.302714,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.067716,
      NULL,
      0.351410,
      7.740759,
      NULL,
      0,
      0,
      0,
      2,
      1,
      NULL,
      1.976957,
      3,
      0,
      0.823493,
      1,
      NULL,
      1,
      NULL,
      NULL,
      4,
      2.945471,
      0,
      3.069414,
      1,
      1.944998,
      NULL,
      1,
      0.608111,
      2.455467,
      4,
      0.167122,
      NULL,
      3,
      5,
      NULL,
      6.317327,
      NULL,
      5.917140,
      3.058259,
      0.001729,
      5,
      NULL,
      1,
      7.689282,
      9.364162,
      3,
      2,
      1.476782,
      0,
      0.409733,
      0.986789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.940778,
      0,
      1,
      NULL,
      0,
      NULL,
      3.402892,
      1.347098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.903078,
      3.653714,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5.236643,
      2.101169,
      NULL,
      0,
      0,
      0.389682,
      NULL,
      NULL,
      NULL,
      1.638432,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.879329,
      0.179264,
      0.159522,
      2.100886,
      1.127751,
      NULL,
      NULL,
      NULL,
      0.408751,
      2.849150,
      0.208960,
      1.260941,
      1.065518,
      1,
      1,
      0,
      0.333015,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.792497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '24431',
      NULL,
      NULL,
      0.766651,
      '',
      '',
      '',
      1.081997,
      '',
      NULL,
      '',
      4,
      5,
      NULL,
      0.575759,
      NULL,
      NULL,
      0,
      NULL,
      1);
commit;
end;
/


