set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9428112';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '042',
      '44144043',
      55.584941,
      58,
      '1321212',
      139.713544,
      2,
      2,
      2,
      '430440',
      3,
      ' 8-13-1979',
      11,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0.071807,
      NULL,
      0,
      1,
      0,
      3.009790,
      NULL,
      NULL,
      1,
      2.112348,
      NULL,
      NULL,
      0.993425,
      7,
      1.665570,
      1.811330,
      0.898825,
      1.755594,
      1.181505,
      4.838697,
      0,
      1.579034,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.864582,
      0.260339,
      2.221992,
      3.880096,
      1,
      1,
      2,
      3.548425,
      3,
      1,
      NULL,
      3.185732,
      0.584583,
      0,
      1.203822,
      0,
      NULL,
      0.761702,
      1,
      1.989750,
      0.783925,
      0.890591,
      NULL,
      0,
      2,
      1.904691,
      0.253537,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      7.557155,
      1,
      7.603394,
      1,
      NULL,
      0,
      1,
      1.900890,
      0.262570,
      0.066196,
      0.372708,
      4.383448,
      NULL,
      NULL,
      0.005656,
      0.143904,
      NULL,
      NULL,
      1,
      5,
      0.778208,
      1,
      7.867993,
      NULL,
      1,
      1.872403,
      3.762479,
      NULL,
      7.291643,
      5.477401,
      0,
      1,
      NULL,
      4,
      0.974453,
      6,
      1.436846,
      NULL,
      2.087591,
      0,
      5,
      0.715296,
      NULL,
      1.617237,
      NULL,
      NULL,
      1,
      NULL,
      1.614318,
      1.934568,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.963827,
      1.650164,
      NULL,
      1,
      0.779752,
      1,
      NULL,
      1.295742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.455821,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.186471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.134425,
      2.463052,
      7.000448,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.835622,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.038658,
      2,
      0.144409,
      1.140548,
      1,
      0.449150,
      3,
      0.600138,
      2.377568,
      3.294318,
      1.026532,
      1.907311,
      0.431019,
      0,
      0.813857,
      0,
      NULL,
      1.227064,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.425725,
      NULL,
      '',
      '',
      1.478699,
      '',
      '',
      NULL,
      1.041572,
      '',
      NULL,
      '',
      4,
      2.575886,
      3,
      2.269510,
      1,
      2,
      0,
      NULL,
      NULL);
commit;
end;
/


