set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006782';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      35.500602,
      31,
      '2203123',
      180.309550,
      NULL,
      2.390323,
      1,
      '042200',
      3.461594,
      NULL,
      21,
      45,
      1.125995,
      NULL,
      NULL,
      1.157446,
      0,
      0,
      0,
      1,
      0.871222,
      1.286450,
      0,
      1.092985,
      1,
      2,
      0,
      NULL,
      0.241737,
      1.233850,
      5,
      NULL,
      1,
      0,
      1.987046,
      1,
      0.275706,
      NULL,
      1.234333,
      NULL,
      1.125834,
      0.188053,
      NULL,
      NULL,
      1.736681,
      NULL,
      NULL,
      0.603429,
      0,
      0.006009,
      0.212678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.989632,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.944346,
      NULL,
      0,
      NULL,
      2,
      2,
      0,
      1,
      1,
      6,
      1,
      NULL,
      9.624292,
      1,
      1.888808,
      0.885557,
      1.999528,
      0.346246,
      NULL,
      1,
      1,
      0,
      1.914376,
      1,
      0.991496,
      NULL,
      2.110546,
      NULL,
      NULL,
      NULL,
      NULL,
      0.701230,
      0,
      1.406123,
      NULL,
      1,
      1,
      0.651134,
      6,
      NULL,
      3.452653,
      8,
      0.886368,
      NULL,
      3,
      2.977880,
      NULL,
      0,
      NULL,
      1,
      5.527241,
      0.816802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.097150,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.708269,
      0.346033,
      3.531770,
      2.103002,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.473006,
      0,
      0.292698,
      1.135159,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.371141,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.677903,
      3,
      3.802269,
      0,
      NULL,
      0,
      1.962581,
      NULL,
      0,
      0.917504,
      0.211243,
      NULL,
      1,
      0,
      1.915638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.158357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.298759,
      '23304',
      '',
      NULL,
      0,
      NULL,
      NULL,
      '',
      0.852326,
      '32422',
      '',
      '',
      4.565938,
      2,
      0.887169,
      3.746148,
      0.288497,
      1.282975,
      2.984220,
      3,
      1);
commit;
end;
/


