set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006782';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '024',
      '44340342',
      NULL,
      29.301014,
      '1331323',
      NULL,
      5,
      3.783571,
      0,
      '300340',
      1.130127,
      ' 2-21-1987',
      9.347560,
      15.634575,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.850649,
      0.266189,
      NULL,
      0,
      3,
      0,
      1,
      0,
      5.414276,
      NULL,
      1.002341,
      NULL,
      NULL,
      5.752195,
      1.702603,
      NULL,
      1.859192,
      1,
      1,
      4,
      1,
      1.825250,
      1,
      0,
      1.414467,
      NULL,
      NULL,
      0.170827,
      NULL,
      NULL,
      0.041646,
      0.253720,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.176184,
      0.219933,
      0.589198,
      0.904105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.483403,
      1,
      7,
      NULL,
      NULL,
      1.983283,
      NULL,
      NULL,
      1,
      0,
      7,
      0.674464,
      0,
      0.759522,
      NULL,
      0.911728,
      NULL,
      1.408607,
      NULL,
      5,
      0.250253,
      1.315051,
      NULL,
      0.575901,
      3.701876,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.453114,
      NULL,
      NULL,
      1.802147,
      5,
      5.262305,
      4.995027,
      8.558015,
      4,
      NULL,
      5.722023,
      NULL,
      1.891812,
      5,
      1.813465,
      0,
      1,
      0,
      1.602596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      1.686005,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.580620,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      3.042918,
      1.536105,
      1,
      2,
      1.209778,
      NULL,
      NULL,
      NULL,
      1.912881,
      1.826789,
      7,
      0.448944,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.702766,
      3.497379,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.256250,
      0,
      1.851007,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0.592931,
      1.046897,
      0,
      0.928982,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.419438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '30202',
      '',
      '',
      1.046441,
      '',
      '',
      '',
      NULL,
      '14334',
      '',
      '',
      2.240363,
      2.181629,
      1.424643,
      2.527602,
      3,
      0,
      1,
      2,
      1);
commit;
end;
/


