set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006782';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01120333',
      38,
      NULL,
      NULL,
      NULL,
      3,
      3.842770,
      0,
      '422211',
      3,
      '11- 7-2003',
      21.059289,
      3.032737,
      0.821276,
      NULL,
      3.090126,
      NULL,
      3.151523,
      1.621841,
      1.453542,
      1.700858,
      1,
      NULL,
      0,
      1,
      NULL,
      3.443146,
      0.168381,
      1,
      0,
      0.060682,
      1.125034,
      1.698119,
      1,
      1.696770,
      NULL,
      1,
      4,
      0,
      NULL,
      2,
      1.304822,
      0.103600,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.171668,
      1.310375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.991468,
      NULL,
      1.267406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.362230,
      0.563366,
      1,
      0.085618,
      1,
      3.848110,
      0.012781,
      1.372705,
      0.295156,
      1,
      1.873814,
      NULL,
      NULL,
      1,
      0,
      0.871402,
      1.936718,
      1.630837,
      NULL,
      0,
      3,
      5.539902,
      NULL,
      1.630183,
      NULL,
      5,
      1,
      0,
      1.808424,
      1.060203,
      0.048532,
      0.265883,
      0.296974,
      1.914900,
      2.698319,
      2,
      9.982580,
      1.719576,
      9.139620,
      6,
      6.909929,
      NULL,
      2,
      8,
      1.374181,
      1,
      0.787248,
      NULL,
      0.890393,
      0.488817,
      0,
      0.528604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434964,
      1.998083,
      1,
      NULL,
      1.139671,
      1,
      1.603890,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.578949,
      NULL,
      NULL,
      NULL,
      NULL,
      0.274654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.899797,
      NULL,
      NULL,
      NULL,
      1.887572,
      NULL,
      3,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.170955,
      1,
      0.192056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.640095,
      3.277370,
      2,
      1.260193,
      0,
      1.039468,
      NULL,
      2.856230,
      1,
      1,
      NULL,
      0.322594,
      1,
      1,
      1,
      0.326302,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '40022',
      '',
      '',
      1,
      '',
      NULL,
      '',
      3.909357,
      '24021',
      NULL,
      '',
      1.943540,
      5.109291,
      2,
      2.029763,
      0.775129,
      0,
      3.560528,
      1.169141,
      0);
commit;
end;
/


