set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9756071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '421',
      NULL,
      7.707258,
      55.201601,
      '4141310',
      NULL,
      5,
      2,
      2,
      '014033',
      1,
      ' 6-19-1991',
      NULL,
      173,
      0,
      NULL,
      0.401071,
      NULL,
      NULL,
      0,
      0,
      3.037438,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0.541948,
      1.663784,
      1,
      0.159923,
      1.436542,
      0,
      0.390606,
      NULL,
      0,
      0,
      3.471393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.210895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635110,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.947577,
      0.515735,
      0,
      1,
      0.072736,
      0.492554,
      0.661404,
      1.040338,
      0.399236,
      NULL,
      0.434396,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.960511,
      NULL,
      0,
      NULL,
      0,
      1.254038,
      NULL,
      0.306970,
      0.906507,
      NULL,
      0.344513,
      0,
      1.156131,
      NULL,
      1,
      1.251688,
      0,
      0,
      0.891509,
      1,
      0.444214,
      0.165146,
      1.802924,
      1.091474,
      0.806183,
      NULL,
      1.540888,
      NULL,
      1.285494,
      NULL,
      0.505900,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.200526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.361283,
      NULL,
      0,
      1,
      0.412245,
      0.122074,
      0,
      0.824589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.850420,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.147400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.296849,
      0,
      NULL,
      0.556626,
      0,
      0.293342,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.613690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.489808,
      0,
      1.862544,
      1,
      0,
      1.943675,
      NULL,
      0.181531,
      1.422485,
      NULL,
      NULL,
      NULL,
      0,
      0.188895,
      1,
      1,
      1.121165,
      1.432542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '1241',
      '32014',
      NULL,
      0.808602,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      5,
      2,
      3,
      0,
      1,
      0,
      3,
      NULL,
      0.668724);
commit;
end;
/


