set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9756071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-8-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '213',
      '02313322',
      NULL,
      31,
      NULL,
      NULL,
      2,
      NULL,
      3,
      '214402',
      NULL,
      '10- 9-2000',
      NULL,
      234,
      NULL,
      NULL,
      3.611600,
      0.802867,
      1,
      1.078500,
      NULL,
      0,
      0,
      NULL,
      0.015756,
      1,
      3.580903,
      1.235538,
      0.635901,
      1.422227,
      NULL,
      1.599840,
      0.075035,
      0.154747,
      0.379010,
      NULL,
      0.724707,
      0.736713,
      2.147357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.884720,
      1.191222,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.979567,
      0.184796,
      1,
      0.984710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.512867,
      1,
      0,
      0.314643,
      1,
      NULL,
      1.886955,
      0,
      1.234263,
      1.178065,
      0,
      0,
      0.747325,
      0,
      1,
      NULL,
      0.123575,
      0.281122,
      NULL,
      0.994294,
      1.489860,
      0.168779,
      1.641423,
      NULL,
      0.047241,
      NULL,
      0,
      1,
      1.362390,
      0,
      NULL,
      NULL,
      1.264624,
      0,
      0,
      1,
      1,
      1,
      0.659016,
      NULL,
      NULL,
      0.045357,
      1.631486,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      8.325272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.770867,
      NULL,
      0.731482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.051750,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.528599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.576415,
      1.205261,
      0,
      1,
      0.200547,
      NULL,
      NULL,
      NULL,
      1.186164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.085107,
      1.017978,
      NULL,
      1,
      1,
      1.653753,
      NULL,
      1,
      1,
      1,
      1,
      1.505620,
      NULL,
      0.517298,
      0,
      1,
      1.198469,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.406105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      1.986927,
      '',
      NULL,
      '',
      1,
      2,
      1.209571,
      1,
      2,
      0,
      0.214294,
      3.985562,
      NULL);
commit;
end;
/


