set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9209216';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '133',
      '01100323',
      47.530778,
      60,
      '0413402',
      6,
      4,
      NULL,
      1,
      '122124',
      4.928977,
      ' 7- 9-1997',
      62,
      47,
      1,
      NULL,
      3,
      0.333572,
      1.699454,
      0.299307,
      0.241747,
      2,
      3,
      0.762053,
      1,
      0.298444,
      3.214088,
      0.295518,
      NULL,
      0,
      1.291816,
      0,
      5,
      0.154322,
      1,
      NULL,
      1,
      0.986580,
      0,
      0,
      1.410273,
      0.206731,
      0,
      0.542063,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.181522,
      NULL,
      1.003049,
      1.697493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.218390,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      1.544550,
      1,
      0.558719,
      0.527849,
      0,
      1.460091,
      NULL,
      1.817981,
      0.613511,
      0,
      0.133804,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.570580,
      3.825580,
      2,
      3.974998,
      NULL,
      1,
      2,
      0.514942,
      2,
      8.823729,
      5,
      3.462658,
      NULL,
      NULL,
      NULL,
      4,
      3,
      3.786218,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.478446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.364910,
      1,
      NULL,
      1.820841,
      1,
      0.873815,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.864205,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      1.085388,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.897846,
      NULL,
      1,
      0.394534,
      3.247769,
      0.695215,
      1.923254,
      3,
      1.921806,
      NULL,
      1.566674,
      1.949687,
      0.636423,
      0,
      1,
      0,
      0.266164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.505888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.208291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.148195,
      3,
      3.450164,
      0,
      0.326999,
      1,
      1,
      '40042',
      '10211',
      NULL,
      2,
      '12333',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.739851,
      4,
      0.449159,
      0,
      4,
      NULL,
      0.829145,
      NULL,
      1.367659);
commit;
end;
/


