set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9209216';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '213',
      '02242330',
      54,
      35,
      NULL,
      12,
      NULL,
      NULL,
      2,
      '322401',
      0,
      '11-24-1987',
      NULL,
      36,
      1,
      NULL,
      NULL,
      1.027193,
      NULL,
      0,
      1.669143,
      1.670425,
      0.112675,
      0,
      0.685123,
      0.317758,
      0.396035,
      1.385585,
      1,
      1,
      1,
      0,
      1.286313,
      1,
      NULL,
      0.310297,
      0,
      0.627760,
      NULL,
      0,
      0.222296,
      0,
      1.173205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.119531,
      NULL,
      0,
      0.897904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.833751,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.878327,
      1.210806,
      0,
      NULL,
      0,
      0.257153,
      1,
      NULL,
      1.567549,
      0,
      1.845711,
      1.431349,
      0.562964,
      NULL,
      0,
      0.546973,
      1.013676,
      0,
      0,
      NULL,
      0.415620,
      3,
      0.201734,
      1,
      3.844944,
      0,
      4.101214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.863382,
      5.918068,
      2.846668,
      0,
      2.871930,
      2.183061,
      7,
      9.134180,
      9.301566,
      0,
      0.653239,
      NULL,
      NULL,
      0.248148,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.817694,
      1,
      NULL,
      1,
      NULL,
      0,
      1.108617,
      1.543446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337165,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.859980,
      0.557306,
      6.826399,
      0.435915,
      3,
      NULL,
      2.557104,
      NULL,
      NULL,
      NULL,
      1,
      3.608789,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.706304,
      3,
      1,
      0.525076,
      NULL,
      2.939322,
      2.521199,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      0.020774,
      0,
      1.776322,
      NULL,
      1.168938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.877035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.465151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.280081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.222587,
      NULL,
      3,
      6.367768,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '30024',
      '21311',
      '',
      1,
      '24431',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      3.716699,
      4,
      NULL,
      4,
      3,
      2.427709,
      1.687638);
commit;
end;
/


