set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9209216';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '031',
      '40441143',
      NULL,
      NULL,
      '2433442',
      10,
      3,
      0,
      NULL,
      '022301',
      3,
      NULL,
      38.308510,
      94,
      0.588338,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      2,
      1,
      2.580489,
      1.045479,
      1.384818,
      NULL,
      1,
      NULL,
      NULL,
      5,
      1,
      4.339599,
      0.798005,
      0,
      0,
      1,
      0.032666,
      4.098595,
      0,
      2,
      1.737486,
      1.511874,
      0,
      NULL,
      NULL,
      0.047705,
      NULL,
      NULL,
      0,
      1,
      0,
      0.729220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.280629,
      0,
      0.591135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      NULL,
      0.184190,
      0,
      1.225090,
      0.226117,
      1.124493,
      NULL,
      1.131832,
      1.923143,
      0,
      0,
      NULL,
      1,
      4,
      0,
      0,
      NULL,
      0.183320,
      4,
      0.842002,
      4.509520,
      1,
      1.266883,
      4.304584,
      3.223972,
      2,
      1.238061,
      0.450678,
      5.673847,
      NULL,
      9,
      5.995740,
      8.652804,
      6,
      3.180784,
      5.732544,
      NULL,
      4,
      1.857911,
      NULL,
      0.476787,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.142493,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.990747,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.209918,
      1.827747,
      1.046002,
      2.018478,
      2.861828,
      NULL,
      0.785555,
      7.959341,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      5.720330,
      1.231264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      NULL,
      0.586949,
      3,
      2,
      0,
      0,
      3.314663,
      1,
      1.677434,
      0,
      0,
      0,
      1,
      0,
      1.584800,
      1.566911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.437767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.063549,
      NULL,
      NULL,
      NULL,
      NULL,
      1.315273,
      NULL,
      NULL,
      NULL,
      NULL,
      3.049694,
      2,
      NULL,
      1,
      3,
      0,
      NULL,
      1,
      1.944275,
      '41233',
      NULL,
      '',
      2,
      '44304',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.268332,
      3.585107,
      3.859179,
      3.533237,
      1.400929,
      0.314755,
      2,
      1.160507);
commit;
end;
/


