set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9209216';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4214',
      '12310422',
      43,
      60,
      '1224442',
      65.068862,
      2,
      NULL,
      0,
      '044141',
      NULL,
      ' 3- 1-2001',
      NULL,
      16.619381,
      0.267032,
      NULL,
      18.410285,
      NULL,
      0.909970,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.370022,
      1.566387,
      0,
      NULL,
      0.056091,
      1,
      1,
      3.959930,
      0,
      3,
      0,
      1.991531,
      1,
      NULL,
      NULL,
      1,
      0.070088,
      0,
      1.467029,
      NULL,
      NULL,
      1.236965,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.361301,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.277422,
      0.000536,
      0,
      1.921529,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0.271112,
      0.480495,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.420658,
      5,
      3.804578,
      NULL,
      6.880937,
      0.985109,
      5.556305,
      0.755814,
      0.723160,
      1.334353,
      1.496981,
      NULL,
      4.135254,
      2.343756,
      NULL,
      0.507862,
      5,
      4,
      NULL,
      4.943307,
      NULL,
      8,
      1.327280,
      NULL,
      0.424261,
      0.033357,
      5,
      2.613991,
      1,
      NULL,
      NULL,
      3.538178,
      1.278872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      0.415047,
      1.943743,
      0.680494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.846058,
      NULL,
      NULL,
      0.403770,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.948399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.532311,
      0,
      0.238266,
      3,
      2.548920,
      1,
      0,
      1.875032,
      0,
      0,
      1.967886,
      NULL,
      0,
      NULL,
      0.201207,
      0,
      1.328119,
      1.936390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.166425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.999030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.034797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.571818,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.589301,
      1,
      0,
      0.698352,
      0,
      NULL,
      2,
      2,
      '00312',
      '02013',
      '',
      2.226180,
      NULL,
      '',
      '',
      0.980533,
      '',
      '',
      NULL,
      3,
      1,
      0,
      0.048775,
      4.136480,
      2.112953,
      3,
      3.061992,
      2.845892);
commit;
end;
/


