set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9209216';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00210441',
      78.850410,
      NULL,
      NULL,
      32.813661,
      2,
      0,
      3,
      NULL,
      4,
      ' 0-16-2003',
      27.690922,
      28,
      1,
      NULL,
      18.699659,
      1,
      0.866442,
      1,
      1.174635,
      2,
      0,
      2,
      1.193258,
      1.956941,
      1,
      1,
      1.477923,
      NULL,
      1,
      0,
      0.224413,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0.224230,
      NULL,
      0.167273,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.830995,
      1.134450,
      0.372389,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.142523,
      0.805677,
      0.775953,
      0.141602,
      1.335281,
      NULL,
      1.350691,
      NULL,
      NULL,
      NULL,
      1.152437,
      0,
      NULL,
      1.623578,
      0,
      0,
      0.683308,
      1,
      1,
      NULL,
      NULL,
      0.158503,
      0.301702,
      0.511188,
      5,
      0.176882,
      0,
      NULL,
      NULL,
      0.105127,
      NULL,
      2.503873,
      NULL,
      2,
      1,
      0.791779,
      1,
      8.403813,
      NULL,
      8,
      3.504134,
      NULL,
      2,
      NULL,
      5,
      3.872407,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.630074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.936334,
      0,
      0,
      0.235093,
      NULL,
      3,
      0.134180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.217000,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5.121068,
      4,
      0,
      0.720190,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.513824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.875648,
      3.563034,
      0.749529,
      2,
      0,
      1.045728,
      3.942293,
      0.672399,
      2,
      3.907554,
      0,
      1.322894,
      0.748585,
      1,
      0.533795,
      NULL,
      1.100072,
      1.062004,
      1.116649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.764965,
      0.701996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.511628,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.788127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.185929,
      2,
      8.568789,
      NULL,
      0,
      1.625993,
      0,
      3.157706,
      NULL,
      '12313',
      '',
      NULL,
      '10324',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      7,
      5.338962,
      NULL,
      3.752809,
      2,
      1.092933,
      2.032126,
      NULL,
      NULL);
commit;
end;
/


