set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9407664';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '14203000',
      45.047398,
      2.338056,
      '1332204',
      12,
      6,
      2,
      3,
      '244121',
      2,
      '11- 4-1986',
      67.186311,
      NULL,
      0.678750,
      NULL,
      NULL,
      1.254134,
      0.961030,
      0,
      1.120074,
      0.442722,
      2.883125,
      0,
      1,
      NULL,
      0.969254,
      0,
      3,
      NULL,
      NULL,
      0,
      0.636641,
      0.071684,
      1,
      0.323603,
      1,
      1,
      4.758935,
      3,
      2.327862,
      0.254528,
      1,
      1.989277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.545541,
      0,
      NULL,
      1.058185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.454311,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.038967,
      4,
      NULL,
      2,
      1,
      2,
      1,
      0,
      NULL,
      0,
      1,
      0.447156,
      NULL,
      0,
      NULL,
      0.539743,
      1.909062,
      0.203749,
      NULL,
      1,
      5,
      2.162918,
      0.231362,
      0.850475,
      1.420575,
      NULL,
      1.484491,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0.022113,
      NULL,
      7.697931,
      5.215845,
      NULL,
      11,
      2,
      2,
      1.988593,
      NULL,
      6.237558,
      0.289195,
      NULL,
      NULL,
      NULL,
      2.438573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.552226,
      0,
      1,
      0,
      0,
      1.671642,
      1.581957,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.058066,
      NULL,
      53,
      1,
      1,
      3,
      1.425697,
      1,
      1,
      0.830459,
      5,
      7,
      2,
      1.542865,
      NULL,
      NULL,
      NULL,
      NULL,
      0.177624,
      NULL,
      6,
      1.917424,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.852320,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.318145,
      0,
      1.260560,
      NULL,
      0.638186,
      1,
      2,
      0,
      1.261080,
      NULL,
      0,
      NULL,
      1.278289,
      0,
      1.817786,
      1.526197,
      1.384552,
      1,
      0.929681,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.992142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '31221',
      NULL,
      2.757771,
      '24234',
      '',
      '',
      0,
      '',
      NULL,
      '',
      3.167291,
      3,
      1,
      3.095232,
      NULL,
      7,
      NULL,
      1,
      NULL);
commit;
end;
/


