set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9407664';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '201',
      '31140200',
      NULL,
      NULL,
      '1322341',
      24.609830,
      3,
      NULL,
      1,
      NULL,
      5,
      ' 5- 3-2002',
      NULL,
      124,
      1,
      NULL,
      2.825513,
      0.480788,
      1.115508,
      1.692780,
      1.315465,
      3.433361,
      1.731544,
      2.335968,
      1.501717,
      0,
      0,
      1.503976,
      1.715589,
      1,
      1.664073,
      1.554796,
      NULL,
      NULL,
      2.535262,
      0,
      1.408508,
      NULL,
      5,
      0,
      2.558483,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.836837,
      NULL,
      NULL,
      0.323570,
      0,
      0.447253,
      1.868797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700289,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.101314,
      0,
      0,
      NULL,
      0.131751,
      1.171455,
      0.462516,
      1,
      1.125541,
      1,
      1,
      0.114090,
      1.512172,
      2,
      0.335653,
      NULL,
      0,
      1.872235,
      0.233280,
      NULL,
      1.100933,
      3,
      3,
      1.365485,
      4,
      0.367603,
      2.471543,
      NULL,
      0.682452,
      0,
      1,
      NULL,
      0.298513,
      0,
      0,
      1.161991,
      NULL,
      3.666640,
      NULL,
      1,
      2,
      7,
      7,
      NULL,
      NULL,
      3.593475,
      1,
      3,
      1.059679,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.117874,
      NULL,
      0,
      0,
      0.104198,
      0,
      0,
      1.862605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      24.675776,
      3,
      0.017939,
      0.455801,
      3,
      1,
      1,
      1,
      1.315795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.735397,
      3,
      3.128373,
      0.223663,
      1,
      0.844991,
      NULL,
      NULL,
      NULL,
      0.309350,
      1.830277,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.459874,
      2,
      0.645000,
      1,
      NULL,
      1,
      1.812388,
      0,
      NULL,
      2,
      0,
      1,
      NULL,
      0,
      0.260051,
      NULL,
      1.531470,
      1.115867,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.807551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1.530562,
      2.081247,
      1.124967,
      1,
      0,
      0.200463,
      1.749432,
      1,
      0);
commit;
end;
/


