set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9407664';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '033',
      NULL,
      13,
      38.000196,
      '1140212',
      27.300071,
      0,
      3,
      3,
      NULL,
      1,
      ' 1-16-2003',
      96,
      203,
      NULL,
      NULL,
      2.895446,
      NULL,
      0,
      1.054707,
      NULL,
      0.450112,
      0.833413,
      NULL,
      NULL,
      0,
      7.104252,
      1,
      1,
      1.873546,
      1,
      NULL,
      0,
      4.795359,
      NULL,
      0,
      3,
      2.715839,
      6,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      0.775461,
      4.916580,
      0,
      3.548624,
      0.546168,
      0.137647,
      0,
      NULL,
      5.122437,
      1,
      5,
      1,
      1,
      0,
      1.210599,
      1,
      NULL,
      1.688053,
      NULL,
      NULL,
      0.677731,
      5.721588,
      1.984163,
      2,
      0,
      0,
      0.180626,
      3.268709,
      3,
      5,
      4.914366,
      1.155730,
      NULL,
      2,
      1.522383,
      NULL,
      5,
      4.798420,
      NULL,
      4,
      0.392988,
      NULL,
      2,
      4,
      1,
      0.299908,
      NULL,
      2,
      3.604639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.600212,
      1.160764,
      1,
      0,
      0,
      1,
      1.768099,
      1.665702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.368041,
      NULL,
      NULL,
      NULL,
      NULL,
      0.812738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.342580,
      1.409012,
      1.506518,
      3,
      0,
      0.029455,
      NULL,
      NULL,
      NULL,
      0,
      2.198954,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220306,
      3.786914,
      1,
      0.373017,
      NULL,
      0.823576,
      NULL,
      0,
      2,
      NULL,
      0.904440,
      NULL,
      0,
      0,
      1.448927,
      0.618228,
      NULL,
      0.998715,
      1.614865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.911524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '20123',
      '11313',
      NULL,
      1.364212,
      NULL,
      '',
      '',
      1.412608,
      '',
      '',
      NULL,
      5.588724,
      0.949683,
      3.303063,
      NULL,
      3,
      3.789730,
      0.943177,
      2.640560,
      3);
commit;
end;
/


