set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9407664';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4401',
      NULL,
      NULL,
      64.987249,
      '1144024',
      52,
      3,
      1.918859,
      1,
      '402244',
      NULL,
      ' 1- 6-1981',
      136,
      28,
      1,
      NULL,
      2.441589,
      NULL,
      0.274507,
      NULL,
      1,
      3,
      0,
      0.305768,
      1.928311,
      0.431108,
      NULL,
      NULL,
      1,
      0.433123,
      0,
      1,
      1.148471,
      1.877051,
      1,
      1.227393,
      0.837143,
      1,
      5,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.263086,
      0,
      1.970874,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.106710,
      1,
      0,
      0.559823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.084103,
      NULL,
      NULL,
      1,
      NULL,
      0.193059,
      NULL,
      0.327158,
      0,
      0,
      0.117500,
      1.075786,
      0.791388,
      0,
      1,
      1.803087,
      1.536276,
      0.611546,
      1.286680,
      NULL,
      1.027404,
      3,
      0.309582,
      1.213902,
      0,
      0,
      1.220673,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0.393348,
      0.138787,
      5,
      2.353556,
      3,
      1.537323,
      2,
      2.769631,
      0.735563,
      5.368444,
      NULL,
      NULL,
      5.432445,
      NULL,
      NULL,
      NULL,
      NULL,
      1.601494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.637381,
      0,
      NULL,
      0,
      0,
      0.505700,
      0.839214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.558585,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      4.188673,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7.615146,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.337954,
      0.516717,
      1,
      1.968217,
      1.580006,
      NULL,
      0.379362,
      1.501351,
      2.151913,
      2.773090,
      NULL,
      1,
      1,
      1.195761,
      0,
      1.849256,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.864495,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      4.755565,
      NULL,
      0,
      3.548958,
      4,
      0.191502,
      3,
      1.751554);
commit;
end;
/


