set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9407664';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3143',
      '11441212',
      52,
      34,
      NULL,
      127.167946,
      4,
      1.404195,
      2,
      '111014',
      2.866828,
      '10- 2-1991',
      98.580080,
      58.992428,
      1,
      NULL,
      3.876421,
      NULL,
      1.684681,
      0.116206,
      NULL,
      1,
      0,
      0.750804,
      NULL,
      1.068400,
      NULL,
      0.114002,
      1,
      0.952193,
      1,
      0,
      3,
      1,
      2.922933,
      2.769896,
      3,
      2.481658,
      4,
      NULL,
      1,
      3,
      NULL,
      0.052633,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.190185,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.966109,
      0.672683,
      0.865945,
      1.523703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.224694,
      NULL,
      1,
      1,
      0,
      1.713553,
      NULL,
      1,
      1,
      0.428407,
      0.884726,
      0,
      1,
      0.902653,
      0.471501,
      1,
      0.016240,
      NULL,
      0.661032,
      3.632600,
      1.465291,
      NULL,
      1.585410,
      NULL,
      0,
      1,
      1.385400,
      0,
      NULL,
      4,
      1,
      1.541765,
      0,
      NULL,
      0.953190,
      4.360867,
      2,
      4,
      3,
      0,
      0,
      NULL,
      0,
      4,
      NULL,
      5,
      1.489387,
      NULL,
      NULL,
      1,
      1.995676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.329577,
      0.464851,
      NULL,
      1,
      0,
      NULL,
      0,
      0.381331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.831741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.068130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.885164,
      5.907587,
      4.651551,
      NULL,
      0,
      0.104852,
      NULL,
      NULL,
      NULL,
      NULL,
      1.229631,
      0.858609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      1.916902,
      3.157057,
      1.747673,
      1.083886,
      3.788950,
      0.566941,
      2.324966,
      NULL,
      NULL,
      0.957650,
      1,
      1,
      1,
      0.887156,
      0.165213,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.270528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.296306,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      2.747372,
      NULL,
      2,
      2,
      3,
      NULL,
      0,
      2,
      0);
commit;
end;
/


