set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9526255';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-4-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      NULL,
      NULL,
      '4313024',
      0,
      0,
      2,
      3,
      NULL,
      2.969778,
      NULL,
      9,
      NULL,
      0,
      NULL,
      2.194413,
      0,
      1.127519,
      0.771431,
      0,
      1.460783,
      0.550625,
      NULL,
      0,
      1.705419,
      NULL,
      1.589497,
      1,
      1,
      1,
      1.817384,
      2,
      1,
      1.965635,
      0,
      NULL,
      NULL,
      3,
      NULL,
      3.337532,
      1.545043,
      NULL,
      0,
      NULL,
      NULL,
      0.008639,
      NULL,
      NULL,
      3.109534,
      0.077871,
      0.360802,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.222518,
      1.183556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.444183,
      0,
      0,
      1.499384,
      0.255777,
      0.744582,
      NULL,
      1.829164,
      1,
      1.739718,
      1.032833,
      1.535454,
      0,
      0,
      NULL,
      1,
      0,
      1.729642,
      1,
      NULL,
      0,
      2,
      1.600081,
      1.075789,
      1.413588,
      NULL,
      2,
      NULL,
      2.494796,
      2.063313,
      NULL,
      1,
      0,
      0.539218,
      3.946296,
      0.257574,
      1,
      4,
      NULL,
      2.591612,
      0,
      1,
      0,
      NULL,
      0.786050,
      2.306033,
      8,
      0.540991,
      2.478353,
      NULL,
      0.495429,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.267487,
      NULL,
      1,
      1,
      0.948816,
      0.582586,
      0.226443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.895513,
      NULL,
      9.299948,
      1.207711,
      0,
      6.408929,
      0.870450,
      0.001163,
      1.528479,
      1,
      4,
      5,
      3.978824,
      1.444964,
      NULL,
      NULL,
      NULL,
      1,
      0.634687,
      2,
      1,
      0.495476,
      NULL,
      0.226214,
      NULL,
      NULL,
      NULL,
      1.478817,
      5.564450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.932988,
      0.689769,
      1,
      NULL,
      3,
      3,
      1,
      2.049861,
      1,
      1,
      0,
      0.242239,
      1.493796,
      NULL,
      NULL,
      1,
      1.579776,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '42134',
      '',
      '',
      0.997350,
      '',
      NULL,
      NULL,
      0,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


