set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9526255';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '232',
      '43',
      21.695654,
      13.720407,
      '2420210',
      24.930717,
      0,
      0.121854,
      1,
      '443431',
      4.848057,
      NULL,
      46.053923,
      9.295271,
      NULL,
      NULL,
      0,
      0.057882,
      2,
      1.253390,
      NULL,
      0.749431,
      0,
      3.812227,
      1.740257,
      0,
      NULL,
      1.595711,
      1.892619,
      NULL,
      0,
      1.129884,
      3,
      0,
      0,
      1,
      0.470369,
      1.173579,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.174124,
      0.524248,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.816545,
      0.652859,
      1.916481,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.312794,
      0.331080,
      0.063692,
      0.056030,
      0,
      1,
      1.697110,
      0,
      0.620082,
      0.834827,
      0,
      NULL,
      1.961333,
      1,
      0,
      1.550871,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.222895,
      1.742311,
      0.331243,
      1.532063,
      3.790089,
      NULL,
      NULL,
      NULL,
      NULL,
      2.037545,
      1.958323,
      3,
      1.275772,
      1.862847,
      0,
      0,
      NULL,
      2.326444,
      10.739080,
      6,
      NULL,
      6.168909,
      2.636450,
      1.986095,
      3,
      1.808459,
      NULL,
      NULL,
      5.870390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.487001,
      0,
      0,
      0,
      NULL,
      0.449948,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.994442,
      NULL,
      7.158665,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.600576,
      0,
      0,
      0.681600,
      NULL,
      4.456140,
      1.890315,
      NULL,
      2.839155,
      0.931295,
      1,
      7.382485,
      1,
      NULL,
      NULL,
      0.744830,
      7,
      1.084611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.581097,
      3,
      1,
      1.394478,
      1,
      NULL,
      0.869504,
      1,
      NULL,
      1.408400,
      0.638480,
      0,
      1.050076,
      0.762709,
      NULL,
      0.625379,
      0,
      1.061213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.133432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '03043',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


