set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9526255';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '113',
      '13240122',
      NULL,
      NULL,
      '4322243',
      169,
      0,
      1.886034,
      NULL,
      '101030',
      1,
      ' 7-29-1977',
      39.438899,
      53,
      1,
      NULL,
      1,
      1.892521,
      1.705688,
      NULL,
      0,
      0.730886,
      1.283167,
      NULL,
      0.378987,
      NULL,
      1.492572,
      1.471828,
      NULL,
      0,
      0.890972,
      1,
      0.254133,
      0.161571,
      1.891044,
      NULL,
      1.162175,
      0.591433,
      0.655256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.743617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.560130,
      0.231464,
      0.097151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.156138,
      1.045186,
      0.662984,
      0,
      1.240568,
      0.013322,
      0.377222,
      NULL,
      1.481396,
      NULL,
      NULL,
      NULL,
      1.797048,
      0,
      0,
      0.242821,
      0.117119,
      1.946820,
      0.140970,
      NULL,
      1.085313,
      2,
      0,
      NULL,
      3,
      1.959336,
      NULL,
      3.521961,
      NULL,
      NULL,
      NULL,
      NULL,
      5.823936,
      NULL,
      NULL,
      NULL,
      1.120273,
      4,
      0,
      6.023204,
      9,
      9.998257,
      0,
      NULL,
      6,
      3.671824,
      2.671919,
      2,
      0,
      NULL,
      NULL,
      0.042839,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.103129,
      NULL,
      NULL,
      1,
      0.433932,
      0.527438,
      1.059189,
      0.343240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.387913,
      NULL,
      NULL,
      NULL,
      NULL,
      0.681220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.327579,
      1.923255,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.070851,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666125,
      NULL,
      NULL,
      0.619266,
      0,
      3.389658,
      1.735466,
      1.346493,
      0.360362,
      1.418634,
      1,
      0.018188,
      0.404186,
      NULL,
      0.903555,
      0.947877,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.364490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.630674,
      '22304',
      '',
      NULL,
      1,
      NULL,
      NULL,
      '',
      1.583929,
      '',
      '',
      '',
      0.548824,
      3.745710,
      0.728888,
      NULL,
      3,
      1,
      1.066089,
      0.863845,
      1.627478);
commit;
end;
/


