set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9526255';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '314',
      '31412213',
      56.234525,
      79,
      '0421310',
      120.161846,
      5,
      1.050398,
      2,
      NULL,
      NULL,
      ' 7-25-2000',
      18.172262,
      22.272604,
      1.446456,
      NULL,
      1,
      0,
      1.645511,
      1,
      NULL,
      0,
      1,
      2.043428,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      0.999197,
      0,
      0,
      NULL,
      0,
      NULL,
      1.524839,
      NULL,
      0.304139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.825865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.928169,
      1.422019,
      NULL,
      1.785380,
      1.458799,
      1.836627,
      1,
      NULL,
      0,
      1.373676,
      NULL,
      1.509177,
      0,
      0,
      0.372954,
      0.427859,
      1.539556,
      0.290635,
      NULL,
      NULL,
      4,
      0,
      NULL,
      1.598643,
      NULL,
      3.662398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.464991,
      5.981137,
      1.175298,
      1.026489,
      NULL,
      1,
      3.617494,
      6,
      4,
      7,
      0.783472,
      7,
      1.378433,
      1.055133,
      1.716336,
      1.178749,
      NULL,
      NULL,
      NULL,
      1.921363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.111262,
      0.368448,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.601898,
      NULL,
      NULL,
      NULL,
      NULL,
      0.823687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.571624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      8,
      NULL,
      0.082130,
      NULL,
      0.274449,
      NULL,
      NULL,
      NULL,
      1.453917,
      NULL,
      1.661693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.762992,
      1.878382,
      0.720337,
      0,
      2,
      2.914973,
      1,
      0,
      1.182522,
      NULL,
      NULL,
      0.003913,
      0,
      1.483615,
      NULL,
      1,
      1,
      1.148890,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.662420,
      NULL,
      NULL,
      '',
      0.581619,
      NULL,
      '',
      '',
      1.365707,
      '',
      '',
      '',
      2,
      2.085541,
      2.554060,
      5.928889,
      NULL,
      3,
      0.695935,
      1,
      3);
commit;
end;
/


