set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9526255';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4432',
      '34213121',
      41.315845,
      6.116899,
      '3413321',
      41,
      2,
      3.609285,
      3,
      '311401',
      3,
      ' 1- 5-1984',
      58.502618,
      6.998086,
      0.566723,
      NULL,
      2.132807,
      1,
      1.956885,
      1,
      0.579862,
      2.539613,
      1.495776,
      NULL,
      0.040454,
      1.041122,
      3,
      NULL,
      0,
      NULL,
      0.381200,
      1,
      NULL,
      1,
      1.283073,
      NULL,
      0,
      0,
      4.421272,
      0,
      1.401052,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.351357,
      1,
      0.266277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.617760,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.672685,
      1.871178,
      NULL,
      NULL,
      0.021097,
      3,
      1,
      1.368998,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.770213,
      NULL,
      NULL,
      0.001321,
      NULL,
      NULL,
      1,
      2.322774,
      4.213284,
      1.475833,
      4,
      2.903580,
      1,
      4,
      1,
      0.239544,
      3.870513,
      0,
      1,
      1,
      0,
      1,
      6,
      4.446606,
      2,
      7,
      0,
      6.643446,
      1.100607,
      NULL,
      NULL,
      0.371044,
      2,
      0.415728,
      1,
      0.224436,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0.215605,
      0,
      NULL,
      0.035191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.152841,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.235827,
      5.009620,
      2.083251,
      2.639536,
      1,
      1.959371,
      NULL,
      NULL,
      NULL,
      NULL,
      0.728568,
      1.145124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.303735,
      NULL,
      NULL,
      0,
      NULL,
      2.239563,
      NULL,
      3,
      1.557428,
      2,
      1.542746,
      1.523508,
      0.759330,
      0.487731,
      0,
      0.260313,
      NULL,
      0.185637,
      0,
      1.277393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.648977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '12222',
      '',
      '',
      0.272935,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2,
      4.318356,
      3,
      0,
      3,
      NULL,
      3.187076,
      0,
      1);
commit;
end;
/


