set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9526255';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3003',
      '41441041',
      79,
      NULL,
      '3341223',
      NULL,
      6,
      0.343290,
      0,
      '011411',
      3,
      '11- 8-2003',
      7.272058,
      6.246760,
      1.389568,
      NULL,
      1.728920,
      1.702735,
      1,
      0,
      0,
      1,
      0.185146,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.028235,
      5.793293,
      0,
      0.685470,
      NULL,
      1,
      NULL,
      7,
      0,
      NULL,
      0.713119,
      NULL,
      1.619733,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.860491,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.174445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.241683,
      1.815115,
      1.468038,
      1.859975,
      1,
      1.683908,
      0.600794,
      2.942690,
      1.214864,
      0,
      1.164411,
      2,
      1.110778,
      1,
      1,
      1.508184,
      0,
      NULL,
      1.566759,
      1,
      0,
      0.627494,
      NULL,
      2.011516,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.994867,
      1,
      0.608110,
      1.257107,
      8.042001,
      4.115365,
      NULL,
      7,
      5.983269,
      11,
      2.049714,
      3.378365,
      0.008781,
      2,
      2,
      NULL,
      1,
      3,
      0.020855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1.930944,
      NULL,
      0.654382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800399,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.496193,
      1,
      NULL,
      1,
      NULL,
      2.454170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4.023721,
      0,
      5,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.263048,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2,
      0.329361,
      1,
      1.303904,
      NULL,
      NULL,
      0.027480,
      0.076248,
      NULL,
      0,
      0,
      0,
      NULL,
      0.320455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      4,
      NULL,
      2.733121,
      0.439342,
      1.859094,
      0,
      NULL,
      3.516647,
      3.705983);
commit;
end;
/


