set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9333174';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-2-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '03',
      NULL,
      NULL,
      '0401004',
      84.900057,
      2,
      0,
      NULL,
      '201324',
      1,
      ' 2-21-1982',
      30,
      51,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1.105016,
      0.783140,
      0.448269,
      1.824981,
      NULL,
      1.940334,
      2.088489,
      NULL,
      2,
      0,
      NULL,
      0,
      1.983955,
      NULL,
      1.688168,
      1.937409,
      1,
      0,
      1.907408,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.754779,
      NULL,
      NULL,
      0,
      0.992741,
      NULL,
      0.915674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.561588,
      0.845226,
      1.222586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.548491,
      1.614082,
      1.391822,
      0,
      0.668239,
      1.187800,
      0.736417,
      0.672258,
      1,
      1.790226,
      0.879389,
      1,
      NULL,
      1,
      0.715035,
      1,
      0.578739,
      0.913931,
      NULL,
      0,
      1.727585,
      0.109499,
      0,
      1.496476,
      0,
      1.123518,
      0.344322,
      NULL,
      1,
      NULL,
      0.471784,
      0.481893,
      1.341356,
      2.805241,
      1.102381,
      0,
      5.712520,
      1.858126,
      NULL,
      1,
      1.929912,
      1.287596,
      1,
      7.138677,
      NULL,
      0.271914,
      1.126688,
      1.545237,
      NULL,
      NULL,
      9.631256,
      0.272587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1.728050,
      0,
      1,
      0.705015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.653535,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.787721,
      NULL,
      0.059421,
      NULL,
      NULL,
      NULL,
      0,
      4.331669,
      0.702614,
      3,
      4.030763,
      1,
      0.382056,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1.980768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.688943,
      1,
      NULL,
      0.570131,
      1,
      NULL,
      1,
      3,
      1.167679,
      1.740758,
      1,
      1.151825,
      0.793527,
      NULL,
      0.078193,
      1.735130,
      0,
      1.342283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '30433',
      '',
      NULL,
      1.142616,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


