set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9333174';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-7-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '124',
      '20',
      25,
      NULL,
      '3422120',
      19.164907,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 7- 3-1983',
      49,
      NULL,
      1.623362,
      NULL,
      NULL,
      3,
      1.040209,
      1,
      0.460060,
      1.098373,
      NULL,
      2.081190,
      1.719140,
      1,
      1.649992,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      0.740669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.824860,
      NULL,
      1.127366,
      0.212542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.326892,
      1.538034,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.567934,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      1.481595,
      1,
      NULL,
      1,
      0,
      0.986403,
      0.792121,
      0,
      0,
      0.185219,
      NULL,
      NULL,
      1,
      0.412733,
      0,
      1.679951,
      1,
      1,
      1.247506,
      NULL,
      1,
      0.485661,
      1.216244,
      1.559259,
      0,
      1.437012,
      0.365743,
      1.396365,
      1.727240,
      1,
      4,
      2.053703,
      NULL,
      3.614054,
      4.364211,
      2,
      2,
      0,
      NULL,
      NULL,
      0.379569,
      NULL,
      NULL,
      8.990705,
      0.141370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.724706,
      1,
      1,
      0.915603,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.799696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.544939,
      1,
      0.023846,
      NULL,
      NULL,
      NULL,
      1.289133,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772438,
      1,
      1,
      1.887867,
      1,
      0.474768,
      0,
      1,
      1,
      3.787687,
      1.932396,
      0.422226,
      0,
      0.524487,
      1,
      0,
      1,
      0.723579,
      0,
      0.441263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.307451,
      '14241',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      2,
      1.872136,
      1.577706,
      3.291019,
      2.953672,
      1.925539,
      3.141395,
      3.866315);
commit;
end;
/


