set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8134602';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '234',
      '21234000',
      NULL,
      61.598296,
      '2223231',
      34,
      3,
      1,
      1,
      '420342',
      NULL,
      '10-14-1983',
      22,
      46.054547,
      1,
      NULL,
      0,
      1,
      1,
      1.580308,
      1.963267,
      0.394425,
      0.460285,
      3,
      1,
      NULL,
      1.055083,
      NULL,
      0.054171,
      0.175198,
      0,
      0,
      0.537935,
      0.083522,
      0.799413,
      0,
      NULL,
      1.204170,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.491574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.856657,
      1.049138,
      1,
      0,
      NULL,
      1.878225,
      1.063519,
      1,
      0,
      0.132853,
      NULL,
      0,
      0.135422,
      NULL,
      0,
      0.112532,
      0.764474,
      1,
      0.986123,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      0.831922,
      1.239340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.264002,
      0,
      0.856907,
      0,
      1.634683,
      5.566345,
      5,
      6.327040,
      1,
      4.443723,
      10.297669,
      9.762731,
      NULL,
      0,
      0.321571,
      0.321940,
      NULL,
      NULL,
      5,
      1.465387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.595746,
      0,
      1,
      0.996991,
      1.809829,
      1.713653,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.288585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.687533,
      2.116431,
      3,
      1.022143,
      NULL,
      0.159425,
      1.907750,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.524322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.575405,
      1,
      NULL,
      0.365586,
      0.290718,
      0,
      1,
      1,
      1.712823,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.593411,
      0.683533,
      0.557122,
      0.738351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.798409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.415107,
      '24333',
      '',
      '',
      1.212044,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      NULL,
      1.628935,
      0.364234,
      0,
      1.221817,
      0,
      3.562035,
      0.335855);
commit;
end;
/


