set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8134602';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '314',
      '13021144',
      NULL,
      20,
      '4341231',
      NULL,
      NULL,
      NULL,
      1,
      '312041',
      4.593114,
      ' 3-23-1975',
      64,
      8,
      1.295893,
      NULL,
      0.479066,
      NULL,
      1,
      1.675741,
      1,
      0.162609,
      0,
      3.675997,
      NULL,
      NULL,
      0,
      0.242887,
      1.249236,
      NULL,
      1,
      1.414988,
      0.487210,
      0.048581,
      NULL,
      0.949577,
      0.773541,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.349600,
      1.860792,
      NULL,
      0.482473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.105003,
      1.924922,
      1.105546,
      1,
      0.768650,
      1.775531,
      0.625589,
      1,
      0.050208,
      0.374377,
      1.205546,
      NULL,
      1,
      1.582936,
      1.791472,
      NULL,
      1.788935,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1.999730,
      1,
      NULL,
      0.874400,
      1,
      0,
      0,
      0.533928,
      0.234848,
      1.559179,
      1,
      1,
      0,
      0,
      NULL,
      5.310295,
      5,
      NULL,
      NULL,
      NULL,
      7,
      5,
      1.892059,
      0,
      0,
      0,
      NULL,
      NULL,
      4.591476,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.152853,
      1,
      0,
      1,
      1,
      1,
      0.861663,
      0.090954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.776501,
      0.406991,
      1.054792,
      3.199402,
      NULL,
      0,
      0,
      3,
      2.942687,
      0.939509,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.040336,
      1.244004,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.513864,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1.141507,
      1.992224,
      1.225358,
      0.619510,
      0.452531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.314545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.439283,
      '23014',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.310801,
      '',
      '',
      '',
      2,
      1,
      NULL,
      NULL,
      0.447438,
      0,
      1.176809,
      1,
      NULL);
commit;
end;
/


