set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8134602';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0012',
      '33420233',
      NULL,
      13,
      '2144012',
      41,
      3,
      3,
      3,
      '213340',
      2,
      ' 4-15-1982',
      55.517600,
      NULL,
      0.493215,
      NULL,
      1,
      1,
      1,
      0,
      0.777833,
      1,
      NULL,
      0.216609,
      1.612793,
      NULL,
      NULL,
      NULL,
      1,
      0.403340,
      0.437748,
      1,
      NULL,
      1,
      1,
      1.657810,
      1,
      0,
      1.772202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.913013,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.764296,
      0.748445,
      0.732120,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.892390,
      0,
      1.001680,
      1,
      1.039645,
      0,
      NULL,
      1.433218,
      NULL,
      1,
      1.064909,
      0.080562,
      NULL,
      NULL,
      1.794201,
      0.659098,
      2.626345,
      NULL,
      NULL,
      NULL,
      NULL,
      0.108318,
      NULL,
      NULL,
      0.982858,
      NULL,
      0.843712,
      3,
      1.588974,
      NULL,
      2,
      4.487874,
      7,
      3.733979,
      1,
      0.845492,
      0.547236,
      0,
      NULL,
      NULL,
      8,
      1.153438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716952,
      NULL,
      NULL,
      1,
      0.565092,
      NULL,
      0,
      1.069670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.747224,
      NULL,
      NULL,
      NULL,
      NULL,
      0.119630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.527112,
      NULL,
      NULL,
      3,
      NULL,
      2.701052,
      NULL,
      NULL,
      4,
      8,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.291915,
      0.268759,
      0,
      0,
      1.547752,
      0,
      NULL,
      1.196862,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.089535,
      0,
      1.409479,
      1,
      1.899244,
      0.959112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.187221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      5,
      NULL,
      NULL,
      1.550597,
      2.255865,
      4,
      2,
      0,
      NULL);
commit;
end;
/


