set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8134602';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34013334',
      34.497431,
      71.923487,
      NULL,
      19.454230,
      3,
      1.132869,
      NULL,
      '231412',
      5,
      NULL,
      42,
      14,
      1.180380,
      NULL,
      0.133033,
      0.300589,
      NULL,
      0.141827,
      0,
      0,
      1.377673,
      3.472089,
      NULL,
      NULL,
      1,
      1.957588,
      1.194387,
      0.889006,
      0.124753,
      1.416271,
      0.928838,
      0.082385,
      0.286825,
      1.479222,
      0.203177,
      1,
      0.337562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.578233,
      0.950012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.245563,
      0.568064,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1.089852,
      NULL,
      1.545717,
      0.543630,
      0.447906,
      NULL,
      0.822985,
      0.360080,
      1,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      0,
      1,
      1.191720,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.555841,
      2,
      NULL,
      0.901460,
      NULL,
      6.638307,
      NULL,
      4,
      10,
      3,
      0,
      1.148507,
      0.542922,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1.005404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.393332,
      1.489359,
      2,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.116655,
      NULL,
      NULL,
      NULL,
      NULL,
      2.095403,
      1,
      0,
      1,
      1.145495,
      5.486760,
      NULL,
      0.760695,
      3.632029,
      2.409746,
      0.411483,
      1,
      NULL,
      4.554143,
      NULL,
      NULL,
      NULL,
      1,
      1.118297,
      NULL,
      NULL,
      NULL,
      0.367675,
      2,
      1.557608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.542200,
      NULL,
      0,
      1.807843,
      0.962207,
      2.233682,
      0,
      3.313619,
      1.651892,
      NULL,
      NULL,
      1.477894,
      1.500224,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '40312',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1.634690,
      '',
      NULL,
      '',
      NULL,
      1,
      0,
      2.044892,
      1,
      2.969101,
      3,
      1,
      NULL);
commit;
end;
/


