set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8134602';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-7-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3332',
      '20240133',
      36.284387,
      76.930784,
      '3021214',
      114,
      5,
      0.307425,
      3,
      '103104',
      NULL,
      NULL,
      NULL,
      42.462923,
      1,
      NULL,
      1.460661,
      0,
      1.731391,
      0.877758,
      1,
      1.756281,
      0.695152,
      0.801420,
      1.767668,
      0.746710,
      1,
      0.812303,
      0.531812,
      0,
      1,
      0.204935,
      1.775091,
      1,
      0,
      1,
      0.093957,
      0,
      1.805315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.567674,
      0.997386,
      0.420973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.674976,
      1.954390,
      1,
      1,
      NULL,
      NULL,
      0.731540,
      1,
      NULL,
      1.480834,
      1.316214,
      0.727722,
      1.722564,
      0.195603,
      0.271033,
      1,
      NULL,
      0.101326,
      NULL,
      0.117548,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.595732,
      1,
      0,
      0,
      1,
      NULL,
      4,
      0.091022,
      2.986080,
      5.359640,
      6,
      1,
      2,
      4,
      NULL,
      1,
      2.752370,
      NULL,
      NULL,
      2.134234,
      NULL,
      NULL,
      NULL,
      2.508783,
      1.758940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076299,
      1,
      1,
      0,
      0.525138,
      0.008284,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.343453,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0.757897,
      0.583174,
      1,
      2,
      NULL,
      0.411197,
      2.976225,
      2.236094,
      0.084220,
      2,
      NULL,
      2.233577,
      1.138864,
      2,
      1.917198,
      1,
      0.497522,
      NULL,
      NULL,
      NULL,
      1.449564,
      NULL,
      1.414252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.547251,
      0.394613,
      0.193714,
      NULL,
      1,
      2.314509,
      1.970330,
      1.256973,
      1.519372,
      0.360317,
      1.449956,
      0.060943,
      0.356749,
      0.827338,
      1,
      NULL,
      1.943552,
      0.305742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11213',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      0.888421,
      '',
      NULL,
      '',
      4,
      0,
      1.935712,
      5.179567,
      3,
      5,
      3.138914,
      2,
      0);
commit;
end;
/


