set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9930512';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4204',
      '12133443',
      50,
      55,
      '4141430',
      2,
      5,
      NULL,
      NULL,
      '340310',
      4.574838,
      ' 6- 9-1997',
      39.931090,
      NULL,
      NULL,
      NULL,
      1.782203,
      0,
      NULL,
      1.702679,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      7,
      0.868438,
      0,
      9,
      NULL,
      NULL,
      NULL,
      2.904269,
      4.075134,
      1,
      1,
      0.616732,
      NULL,
      1,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.829262,
      3.341862,
      1,
      0.982813,
      1,
      3,
      0,
      NULL,
      0.721967,
      0.620074,
      1,
      1.986828,
      0.968560,
      NULL,
      2.152435,
      3.684891,
      2,
      2.039578,
      0.782465,
      0.831063,
      0,
      2.897493,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.179103,
      NULL,
      NULL,
      0.233949,
      6,
      NULL,
      1,
      3.660551,
      0.091730,
      4,
      NULL,
      1.494613,
      0.802417,
      1.569691,
      0,
      1,
      NULL,
      1.093606,
      0,
      0.591677,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0.895721,
      1.057929,
      1,
      NULL,
      0.766941,
      NULL,
      NULL,
      NULL,
      NULL,
      1.884417,
      NULL,
      0.864638,
      0,
      4.311718,
      6,
      1.176693,
      3.737746,
      0.408697,
      NULL,
      5,
      2,
      8.152223,
      5,
      NULL,
      3.777517,
      NULL,
      0,
      0.092659,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.988679,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.045086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.823711,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4.796309,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3.230658,
      1,
      0,
      0,
      1,
      1,
      2,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0.674444,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.217865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      '02303',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      3.940446,
      NULL,
      0,
      0,
      3,
      NULL,
      1,
      1.887687);
commit;
end;
/


