set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9930512';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      47,
      NULL,
      NULL,
      11,
      4,
      NULL,
      2,
      '040411',
      NULL,
      ' 7- 8-1993',
      38.278295,
      25,
      0,
      NULL,
      5,
      1,
      1.267576,
      0.599719,
      2.097077,
      1.904735,
      0.999856,
      NULL,
      3,
      1,
      NULL,
      1,
      1,
      1.102245,
      0,
      0.505886,
      10.553182,
      NULL,
      5.283553,
      2.951732,
      6,
      NULL,
      7,
      1,
      NULL,
      3,
      1.985570,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.402326,
      7,
      1,
      1,
      NULL,
      3,
      3.717695,
      0,
      NULL,
      2.993252,
      1,
      3,
      0.010475,
      NULL,
      2,
      1,
      0.017563,
      NULL,
      1.775244,
      0.844952,
      0.236438,
      NULL,
      0.695582,
      1,
      2,
      2.794940,
      0.731629,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      2.244773,
      1,
      NULL,
      3.519313,
      0,
      1,
      0.677062,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.448582,
      NULL,
      NULL,
      0.009847,
      1,
      0,
      0,
      1,
      2.576247,
      1,
      1,
      1.375461,
      1,
      0.447877,
      1,
      0,
      1.194093,
      0.672395,
      1.281568,
      0,
      9.848123,
      2,
      4.200771,
      NULL,
      2.771663,
      NULL,
      4.205569,
      NULL,
      3,
      2,
      5.201553,
      2,
      0,
      1.320102,
      2,
      1.579487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063858,
      0,
      0,
      0,
      1.694813,
      NULL,
      NULL,
      1.567851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.805097,
      NULL,
      NULL,
      NULL,
      NULL,
      3.755524,
      NULL,
      3,
      1,
      1.075021,
      4,
      4,
      NULL,
      1.055053,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.282489,
      4.619375,
      1.513215,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680681,
      NULL,
      NULL,
      3.724569,
      0.080336,
      3.898983,
      NULL,
      0,
      NULL,
      2.675243,
      NULL,
      0,
      0.443264,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.971335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.344197,
      NULL,
      NULL,
      NULL,
      NULL,
      0.948798,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.197654,
      NULL,
      1.743593,
      NULL,
      NULL,
      0,
      3.305861,
      '12434',
      NULL,
      '',
      0.593162,
      '',
      NULL,
      '',
      0.557209,
      '',
      '',
      '',
      2,
      1.942417,
      1.050161,
      NULL,
      1.245458,
      0.021553,
      1.542475,
      1,
      2);
commit;
end;
/


