set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9930512';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2221',
      '11432140',
      40,
      24,
      '1340340',
      28.293085,
      5,
      NULL,
      0,
      '011002',
      1,
      ' 8- 3-1987',
      16.932791,
      19.030483,
      0.115954,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.714233,
      0.617397,
      0.215726,
      0,
      0.209785,
      1,
      5,
      1.894764,
      NULL,
      3,
      8.636483,
      NULL,
      7.884738,
      0.562648,
      4.615474,
      0.578445,
      6.820301,
      0.866889,
      3,
      NULL,
      3,
      1.683635,
      0,
      1,
      NULL,
      NULL,
      0.474261,
      NULL,
      NULL,
      5.944442,
      NULL,
      1,
      2,
      NULL,
      2.070696,
      0,
      NULL,
      1.684077,
      2.298790,
      1,
      0,
      0,
      2.187702,
      2.374296,
      1,
      NULL,
      0,
      NULL,
      7.752261,
      0,
      NULL,
      3.918155,
      0,
      1,
      2.430663,
      0.962246,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.641089,
      0.828237,
      4.847710,
      0,
      5.950712,
      NULL,
      0.548300,
      0.661760,
      0,
      0.019819,
      0,
      5,
      NULL,
      NULL,
      NULL,
      0.066680,
      1,
      NULL,
      0.776740,
      NULL,
      0.953262,
      1,
      NULL,
      1.676825,
      0.874900,
      0.938357,
      3,
      0,
      1,
      1,
      0.142719,
      0,
      1,
      0,
      1,
      0,
      0,
      6,
      8.334535,
      2.025895,
      7,
      NULL,
      3,
      5,
      2.061759,
      7.354132,
      2,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.669641,
      1.907499,
      NULL,
      1.841695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.497622,
      0.970693,
      1,
      1.201781,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.968152,
      0,
      4,
      4.010542,
      1.902288,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.124173,
      1.956581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.622842,
      2,
      0.466326,
      NULL,
      1,
      NULL,
      1.433116,
      1.932002,
      0,
      0,
      2.887707,
      1,
      0.786608,
      1.122952,
      0,
      1.573196,
      0.603543,
      1.598144,
      0.337616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.570323,
      0.654135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.985972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.512280,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      1.738787,
      2,
      1.437220,
      '21120',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      2.175290,
      3,
      1.247167,
      NULL,
      2,
      0.226473,
      2.570075,
      0,
      0);
commit;
end;
/


