set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9930512';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2220',
      NULL,
      44.167853,
      61,
      '2413124',
      21.118860,
      3,
      NULL,
      0,
      '131431',
      4,
      ' 7- 5-1981',
      31,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.686729,
      0.320420,
      1.580605,
      0,
      1,
      1.407791,
      5.648708,
      1.886460,
      NULL,
      0,
      3.749696,
      0.668900,
      1.623011,
      NULL,
      1.811783,
      0,
      NULL,
      1,
      6.639430,
      NULL,
      3.861251,
      NULL,
      3.398409,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.059257,
      NULL,
      2,
      NULL,
      0.821490,
      1,
      NULL,
      3,
      0.994120,
      0,
      1,
      NULL,
      0,
      0.135260,
      0.349264,
      NULL,
      NULL,
      NULL,
      0.255204,
      0.377156,
      1.877158,
      1.807437,
      NULL,
      0,
      2,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1.112339,
      0,
      NULL,
      5.272091,
      0,
      NULL,
      1,
      0,
      0,
      3.990467,
      0.430379,
      3.481452,
      0,
      0.923326,
      1.842722,
      1,
      1,
      NULL,
      0,
      2.018456,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0.939491,
      1,
      0,
      0,
      NULL,
      0.417316,
      2.142696,
      NULL,
      6.463073,
      9,
      NULL,
      4.687315,
      3,
      7,
      NULL,
      0.632786,
      1.924294,
      1.708646,
      0,
      0.725543,
      0,
      4.376085,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0,
      0.033142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.335763,
      1,
      1.543234,
      1,
      NULL,
      7.152083,
      0.389037,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.975313,
      2.395377,
      5.602874,
      0.782563,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.410346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337674,
      1,
      3.153206,
      0,
      NULL,
      3,
      1.063224,
      1,
      1.442727,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.285778,
      1,
      NULL,
      0,
      0.851965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.718157,
      '23331',
      '',
      '',
      1.662619,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      5.733247,
      NULL,
      3,
      NULL,
      2.397404,
      5.886601,
      1,
      1.550600,
      2);
commit;
end;
/


