set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9500607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-9-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      10,
      10.791066,
      '0210134',
      14.794938,
      5,
      1,
      NULL,
      '202422',
      4,
      ' 4-24-1998',
      18,
      42,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.732324,
      0,
      0,
      0.231520,
      0,
      2,
      0.013055,
      NULL,
      0.693774,
      1.207605,
      0.719364,
      0,
      1,
      0.084673,
      0,
      0.885966,
      1.467247,
      1.270416,
      1,
      1.211902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.309128,
      1,
      0,
      0,
      NULL,
      0.883083,
      0,
      3.140315,
      1.535567,
      3,
      NULL,
      0,
      1,
      1,
      2.324944,
      0,
      0.076807,
      3.205574,
      3,
      1,
      1,
      0.984637,
      2.221264,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.259153,
      NULL,
      NULL,
      1.831904,
      0,
      1.233251,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.877285,
      0.744162,
      1,
      NULL,
      1.772724,
      1,
      1,
      0.238252,
      1,
      NULL,
      1.727019,
      1.942545,
      NULL,
      1.116697,
      1,
      0,
      3,
      1.431155,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      0.049593,
      0.894281,
      4,
      3.950688,
      3,
      1.516758,
      3.593873,
      6.327149,
      0,
      NULL,
      NULL,
      2,
      2.258134,
      0,
      NULL,
      NULL,
      5.687729,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      0.889025,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.922476,
      1,
      1,
      1,
      5,
      1.055256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.770905,
      3.195049,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.719150,
      1.411752,
      0.622712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.104948,
      1.082020,
      NULL,
      3.231003,
      2.122871,
      1,
      0.938899,
      0.323634,
      0.245065,
      0,
      NULL,
      1,
      0.733279,
      NULL,
      0,
      1,
      1.612082,
      1.757418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '24201',
      '',
      '',
      0,
      '',
      '',
      '',
      0.283479,
      '',
      '',
      '',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


