set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9500607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '332',
      '24',
      18,
      NULL,
      '1011100',
      23.251924,
      2,
      1.432368,
      NULL,
      '211300',
      NULL,
      ' 2- 3-1996',
      28.646451,
      NULL,
      0.321874,
      NULL,
      NULL,
      0.562403,
      0.722925,
      NULL,
      1,
      3,
      0.225563,
      NULL,
      2,
      1,
      1.201429,
      0.787034,
      0,
      0.185334,
      1.519823,
      1.537501,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.006301,
      1,
      3,
      1,
      1,
      0.549709,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.168053,
      1.534680,
      0.639797,
      0,
      0,
      NULL,
      0,
      1.253160,
      1.551602,
      1,
      0,
      1,
      1,
      0,
      0.886969,
      2.030659,
      0,
      NULL,
      1.423978,
      1.679902,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0.260919,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.113448,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1.831523,
      NULL,
      1,
      1.635328,
      0.479667,
      1,
      0,
      0,
      0,
      NULL,
      1.420683,
      2,
      0.224589,
      1.317528,
      NULL,
      0,
      5,
      0,
      NULL,
      1,
      0,
      1.832995,
      0.484491,
      1,
      3.550080,
      0.286610,
      1.380328,
      NULL,
      4.978557,
      4.866015,
      4,
      2,
      7.027594,
      5,
      1,
      1,
      2.454235,
      2.526001,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.919099,
      1,
      0,
      0.394091,
      0.178409,
      1.721528,
      0.872314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.048907,
      3.520263,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.415287,
      0,
      NULL,
      NULL,
      NULL,
      3.610784,
      2.801449,
      5,
      1.737204,
      NULL,
      0,
      0.649500,
      NULL,
      NULL,
      NULL,
      0.396960,
      0.973367,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      3,
      3,
      0.053314,
      2,
      0,
      3.579668,
      1,
      1.201411,
      1,
      0,
      0,
      0.338621,
      1,
      0.701665,
      0,
      0.486954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.178063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.004552,
      NULL,
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


