set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9500607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '434',
      '02',
      28.372876,
      NULL,
      NULL,
      10,
      1,
      3,
      0,
      '021011',
      NULL,
      ' 9- 9-1981',
      NULL,
      100.380157,
      1,
      NULL,
      1,
      0.976041,
      0,
      1,
      1.593771,
      0,
      0,
      NULL,
      NULL,
      1.339072,
      3.511687,
      1.547640,
      1.500290,
      NULL,
      1.605848,
      1,
      0,
      0.748661,
      0.938745,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      0.275952,
      NULL,
      1.945427,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.892651,
      NULL,
      1.020613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.532649,
      0,
      1,
      3.495126,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.299880,
      0.143374,
      NULL,
      0,
      0.544828,
      NULL,
      1.996851,
      0,
      1.201359,
      0,
      0.317222,
      1.264610,
      0.115891,
      0,
      NULL,
      NULL,
      NULL,
      0.244517,
      1,
      NULL,
      0.458379,
      3,
      0,
      4,
      0.234539,
      0,
      1,
      0.039272,
      0.183113,
      3,
      1.445274,
      1,
      0.824298,
      6.849980,
      3.476490,
      2.045728,
      0.693201,
      5.976309,
      2.552102,
      6.067526,
      3,
      0.998850,
      3,
      0.685745,
      NULL,
      NULL,
      NULL,
      1.786124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.777074,
      1,
      1,
      0.038268,
      1,
      1.270912,
      0.136495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.961201,
      1.172430,
      0.677464,
      NULL,
      2.627626,
      0.333476,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      NULL,
      1,
      0.658876,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.168734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.553522,
      1.523517,
      3,
      NULL,
      2,
      1.852644,
      0.708428,
      0,
      1,
      0.259046,
      1,
      1,
      1.683620,
      0,
      1.037634,
      0,
      0.088647,
      1.420306,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.322735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.351028,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2.104383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


