set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9500607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '341',
      '12334213',
      NULL,
      NULL,
      '2103433',
      68,
      2,
      0,
      0,
      '341034',
      4.013053,
      ' 1-11-1984',
      NULL,
      29,
      1.828398,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      2,
      0,
      0.827358,
      0,
      0.533130,
      NULL,
      0.954801,
      1,
      0,
      0.992860,
      NULL,
      0,
      NULL,
      1.774389,
      0.338472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435695,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.120007,
      0.321511,
      1,
      0.368177,
      NULL,
      0.310177,
      0.606987,
      0,
      NULL,
      1.286860,
      0.045137,
      1.499427,
      1,
      0,
      0.413589,
      0.985990,
      NULL,
      1,
      NULL,
      0,
      1.530992,
      NULL,
      0.102245,
      1,
      0,
      3.639984,
      1.475092,
      1.559534,
      1,
      0.289930,
      1.482280,
      0,
      1.147147,
      0.741039,
      0,
      0,
      4,
      3,
      NULL,
      NULL,
      3.358733,
      NULL,
      NULL,
      5,
      1.417008,
      3,
      NULL,
      1.116726,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.317512,
      0,
      0,
      0.112931,
      1.403377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.746780,
      NULL,
      3,
      3.280311,
      1.125224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.809549,
      2.530578,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.991563,
      1,
      0.550335,
      0.217857,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.454284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0.659122,
      1,
      2,
      1,
      0.096882,
      3,
      0,
      2.664187,
      1,
      NULL,
      NULL,
      0.338687,
      1,
      0.725509,
      1,
      2.876679,
      NULL,
      0,
      0,
      0,
      1.256893,
      NULL,
      NULL,
      1.144187,
      0,
      NULL,
      0,
      0,
      1.902067,
      0,
      1.705372,
      0.669949,
      0,
      0.940832,
      NULL,
      1.530246,
      1.586943,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.486196,
      '31131',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      0.900102,
      '',
      '',
      '',
      4.151282,
      2.036072,
      0,
      3.464097,
      3.033095,
      3,
      3.746472,
      0,
      3);
commit;
end;
/


