set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9500607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '432',
      '22004023',
      48.458511,
      0,
      '4403400',
      29.359172,
      3,
      2,
      1,
      NULL,
      1,
      NULL,
      27,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1.075915,
      1.961905,
      3.315759,
      1,
      0.948475,
      1,
      1,
      4,
      0,
      0.883550,
      0.457295,
      NULL,
      0,
      4,
      NULL,
      0.028827,
      1,
      NULL,
      0.257830,
      4.918648,
      0,
      4,
      2,
      1.233311,
      0,
      NULL,
      NULL,
      1.719221,
      NULL,
      NULL,
      4.925033,
      0,
      5,
      3.635191,
      0.263294,
      NULL,
      1,
      1,
      0.890614,
      0,
      2.129370,
      1,
      3,
      0.762438,
      NULL,
      0,
      NULL,
      0,
      1.993478,
      0.932645,
      NULL,
      0.100221,
      3.453804,
      0,
      0,
      2.336934,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.681329,
      0.656686,
      1.534078,
      1,
      2,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.427080,
      0.464119,
      0,
      1.782792,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5.374462,
      1.088562,
      0.843319,
      5,
      0.608095,
      3.656886,
      0,
      2.456816,
      1,
      5,
      0,
      4,
      3.764784,
      NULL,
      6,
      1,
      7,
      2.178852,
      1.450920,
      8,
      4.809268,
      0,
      6,
      5,
      3,
      5.675525,
      7,
      0.065514,
      1.489192,
      1.449434,
      2,
      0.148192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.728299,
      0.255971,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      3.732879,
      3.097612,
      NULL,
      2.898516,
      1,
      0,
      3,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.338645,
      0,
      4.839986,
      4.854232,
      0.018909,
      0,
      1.971679,
      NULL,
      NULL,
      NULL,
      NULL,
      2.824834,
      1.707663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.496304,
      0,
      1.352621,
      NULL,
      2,
      NULL,
      1.057436,
      1.001318,
      2,
      0.252415,
      1,
      0.510894,
      0,
      0,
      0,
      NULL,
      1.734219,
      0.194531,
      0.367685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.082857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '02343',
      '22124',
      '',
      NULL,
      '',
      NULL,
      '',
      1.486404,
      '',
      '',
      NULL,
      4,
      3,
      NULL,
      1.085686,
      3,
      3,
      3.105038,
      1.772725,
      NULL);
commit;
end;
/


