set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9500607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      65,
      '1203312',
      155,
      2,
      NULL,
      NULL,
      '431201',
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.145160,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.411093,
      0.020973,
      2,
      1,
      NULL,
      1.865663,
      NULL,
      1.360619,
      4,
      0,
      1.444893,
      1.972359,
      7.157138,
      0.912699,
      5.001141,
      1,
      4.485715,
      1.692649,
      3.271364,
      0.387576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.096232,
      1,
      0,
      0.764259,
      1,
      0,
      0.122700,
      3,
      NULL,
      3,
      1.185345,
      NULL,
      1.854695,
      1.027092,
      0.433499,
      0,
      1,
      NULL,
      2,
      5.030291,
      0.519913,
      NULL,
      2,
      1,
      0,
      0.524859,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.014009,
      4,
      0,
      NULL,
      0.598124,
      0,
      0,
      0,
      1.027192,
      NULL,
      NULL,
      0.473413,
      0,
      1,
      NULL,
      0.527720,
      1.318611,
      0,
      NULL,
      1,
      NULL,
      1.877443,
      0,
      0.541131,
      1.759275,
      1.959514,
      0,
      1.398423,
      1.646853,
      1,
      1,
      1,
      NULL,
      1,
      1.474776,
      0,
      4.448593,
      NULL,
      2,
      3.938739,
      5.935744,
      1,
      8.380756,
      2,
      NULL,
      NULL,
      1,
      3.938547,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.029505,
      0,
      1,
      NULL,
      NULL,
      1.680043,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.115715,
      NULL,
      6,
      0,
      2.044547,
      1.765537,
      1.944188,
      1.495207,
      0.163923,
      0.531642,
      4.518919,
      5,
      3.769252,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      4.597927,
      1.484842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.340442,
      NULL,
      0,
      2.886409,
      NULL,
      3,
      2,
      NULL,
      2,
      1,
      1.507562,
      1.414926,
      0.143720,
      0.367699,
      0.972039,
      1,
      NULL,
      0,
      0.918635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.365497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.069816,
      '02100',
      '30114',
      NULL,
      NULL,
      '',
      NULL,
      '',
      1.483064,
      '',
      '',
      '',
      0,
      1,
      2,
      1,
      NULL,
      0.235499,
      3,
      3.874730,
      0);
commit;
end;
/


