set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9500607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1424',
      '41203242',
      6,
      45,
      '1422421',
      NULL,
      3,
      2,
      2,
      '211330',
      2.731998,
      NULL,
      7.952647,
      15,
      1.673738,
      NULL,
      1.213621,
      1.993402,
      0.171441,
      1.656116,
      1.595681,
      3,
      0.010452,
      1,
      2.649500,
      1,
      NULL,
      1.765944,
      1,
      1,
      0,
      0.792692,
      4.770765,
      NULL,
      0,
      NULL,
      5,
      1,
      4.031765,
      0,
      1,
      3,
      1.742903,
      0,
      NULL,
      NULL,
      1.803930,
      NULL,
      NULL,
      2.559366,
      0.977746,
      NULL,
      1.279644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.130081,
      0,
      2,
      5,
      NULL,
      2,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.951368,
      0.568408,
      3.666314,
      1.052991,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.274310,
      0.158634,
      0,
      1.271192,
      0.370194,
      NULL,
      1,
      0.101312,
      1.503377,
      NULL,
      NULL,
      1,
      0.473047,
      0.517941,
      NULL,
      0.168913,
      NULL,
      0,
      NULL,
      0.529116,
      0.585088,
      1.806185,
      1,
      4,
      2,
      0,
      1,
      4,
      NULL,
      6.755039,
      NULL,
      3.546123,
      0,
      0,
      7,
      NULL,
      4.497299,
      7.012582,
      0.002492,
      NULL,
      NULL,
      8.301400,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.798966,
      1.272261,
      0,
      NULL,
      1,
      1,
      0,
      1.073131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.951681,
      2,
      1.101473,
      1.719691,
      NULL,
      NULL,
      0,
      0.683143,
      NULL,
      4.299849,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.706730,
      0.006077,
      4,
      0,
      0,
      1.399486,
      NULL,
      NULL,
      NULL,
      0.906989,
      2,
      0.105209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.191244,
      0,
      0.011279,
      1.695805,
      0.956269,
      0.339446,
      1.861726,
      2.593575,
      0,
      0.389190,
      1,
      NULL,
      1.349283,
      1.996106,
      0.947643,
      0.614756,
      0.657907,
      1.599997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.085142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '22000',
      NULL,
      '',
      1.946024,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      NULL,
      2,
      0,
      3.726692,
      0,
      3,
      0.549990,
      0.987395,
      0.406651,
      2.079665);
commit;
end;
/


