set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9500607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2240',
      '01234110',
      31.887763,
      68.700467,
      '0332313',
      57,
      0,
      2,
      NULL,
      '241043',
      5.820761,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.609130,
      1.328402,
      3.982818,
      0.708465,
      0.148188,
      NULL,
      1,
      1,
      2,
      NULL,
      2,
      0.549506,
      0,
      NULL,
      1,
      1.145408,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      2.629655,
      NULL,
      2.630490,
      0,
      1,
      0,
      NULL,
      NULL,
      0.617190,
      NULL,
      NULL,
      0,
      0.479366,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.226868,
      NULL,
      1,
      0,
      1,
      0.533661,
      1.040611,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.237251,
      1.074659,
      NULL,
      0,
      NULL,
      NULL,
      0.724176,
      NULL,
      NULL,
      NULL,
      0.439190,
      0,
      0.790990,
      1,
      1.919586,
      NULL,
      1.583236,
      0,
      NULL,
      1.872441,
      5,
      1,
      0,
      0,
      NULL,
      0,
      0,
      0,
      1,
      0.091178,
      0,
      NULL,
      NULL,
      1.288100,
      0.032044,
      0.483653,
      5.039555,
      1.526162,
      7,
      8,
      NULL,
      6.155327,
      7,
      8,
      NULL,
      4,
      0.776135,
      NULL,
      NULL,
      NULL,
      0.136033,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.787875,
      0.119938,
      0,
      1,
      0.360719,
      0,
      0.371979,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.165718,
      NULL,
      6.973258,
      0,
      0.544270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.317516,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.334248,
      NULL,
      1,
      3,
      NULL,
      0,
      0.394233,
      NULL,
      NULL,
      0.886711,
      NULL,
      NULL,
      0,
      0,
      1.030858,
      0.184586,
      1,
      1,
      1.141237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '23410',
      '24024',
      '',
      0.749925,
      '',
      '',
      '',
      0.356553,
      '',
      '',
      '',
      0.516698,
      1.347998,
      3,
      NULL,
      3.066813,
      3.648009,
      3.754526,
      0.408129,
      0.727610);
commit;
end;
/


