set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9500607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43034421',
      67,
      65,
      '4221314',
      49,
      NULL,
      1,
      1,
      '113124',
      2.787563,
      ' 0- 5-1983',
      17,
      35.357283,
      0.036289,
      NULL,
      0.787045,
      NULL,
      0.418794,
      NULL,
      0.509154,
      3,
      0,
      1.380063,
      1.609445,
      1,
      1,
      0.317993,
      1,
      0,
      1.126636,
      NULL,
      3.640608,
      1,
      0,
      NULL,
      1,
      1.891533,
      5.716131,
      1,
      0.741749,
      1.060482,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.024579,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.732679,
      0.536320,
      1.518925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.972105,
      0,
      1.919997,
      1,
      0,
      1.624185,
      NULL,
      1,
      1.966321,
      1.953293,
      1.650016,
      1.757897,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      5.578771,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0.848310,
      0,
      NULL,
      1.517645,
      0,
      0.009957,
      NULL,
      3.967458,
      1.448600,
      4,
      7.319311,
      3.449908,
      7.675049,
      6.597596,
      7.267937,
      1.242795,
      NULL,
      4,
      4.501544,
      1.025160,
      0,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.507282,
      0.719433,
      NULL,
      0.680114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.006900,
      NULL,
      5,
      0.184455,
      NULL,
      7,
      1,
      1.790144,
      3,
      NULL,
      1.085648,
      4,
      0.042618,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.811382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.755765,
      0.001775,
      NULL,
      2,
      3.332965,
      2.983992,
      NULL,
      0,
      1,
      1.518244,
      1,
      1,
      1.480128,
      1,
      NULL,
      1,
      0.937865,
      1.851941,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      '',
      0.288898,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      3,
      3.514319,
      3.585719,
      0.420277,
      NULL,
      2.014273,
      1,
      0);
commit;
end;
/


