set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9136650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '020',
      '34',
      13,
      NULL,
      '3113420',
      17.502909,
      NULL,
      2.966335,
      1,
      '232000',
      3.446706,
      ' 9-22-1985',
      NULL,
      8,
      NULL,
      NULL,
      0,
      2.370321,
      0,
      1.518017,
      1.256661,
      0.953821,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1.264497,
      1.009746,
      NULL,
      0.540389,
      0,
      1,
      NULL,
      1.065586,
      0,
      1,
      0.179811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.937203,
      1.194388,
      1.339379,
      0.472089,
      3.866593,
      0,
      3,
      3,
      1.575604,
      1,
      3.726504,
      1.069309,
      0.445930,
      0,
      0.597614,
      1.647222,
      1,
      1.306862,
      0.739175,
      9.302389,
      0,
      1,
      1.373602,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.024087,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.277237,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0.233747,
      NULL,
      1,
      NULL,
      1.178870,
      3.921805,
      0,
      0.261878,
      NULL,
      1,
      0.193881,
      1,
      0,
      5,
      1.268160,
      0,
      4.446673,
      1,
      4.081245,
      0.443968,
      0.365457,
      1,
      0,
      0.079976,
      7.081999,
      7,
      1,
      3.139766,
      5.279246,
      1.027471,
      NULL,
      0,
      0,
      0.985323,
      1,
      3.259514,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.152211,
      1,
      0,
      1,
      1.320769,
      1,
      1.446669,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.381366,
      NULL,
      NULL,
      NULL,
      1,
      1.234622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.257161,
      7,
      1.219717,
      3.309316,
      2,
      7,
      0.391355,
      1.964593,
      1,
      0,
      1,
      0.435482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.854588,
      1.291062,
      1.009616,
      1,
      0,
      NULL,
      NULL,
      3,
      1.873558,
      0,
      0.355337,
      0.434965,
      1.293252,
      NULL,
      1.340634,
      NULL,
      0,
      0.641915,
      1,
      1.610543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.065921,
      NULL,
      NULL,
      NULL,
      NULL,
      0.939133,
      0,
      1.875987,
      NULL,
      0.837858,
      1.761025,
      1,
      NULL,
      NULL,
      '31301',
      NULL,
      '',
      1.859437,
      '',
      '',
      NULL,
      0.201367,
      NULL,
      '',
      '',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


