set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9136650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '203',
      '31',
      23,
      23,
      '0344332',
      65,
      4,
      3.721842,
      3,
      NULL,
      4.142658,
      ' 5-22-1993',
      25.866795,
      2.636261,
      NULL,
      NULL,
      1.405843,
      NULL,
      1,
      1,
      1.206179,
      0.141899,
      3,
      2.510665,
      1,
      1.870401,
      0.512986,
      1.506632,
      0,
      0.097860,
      0,
      1.210766,
      NULL,
      NULL,
      0.173602,
      1,
      1.777825,
      1,
      0.160997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.640488,
      0.210625,
      0.820143,
      0.224521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.253324,
      0.334642,
      1.226255,
      NULL,
      NULL,
      2,
      1.452144,
      1.888159,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1.051552,
      0,
      1.487119,
      0,
      0.948116,
      1.927248,
      0,
      0,
      0,
      1.377264,
      1.949306,
      0,
      0.378419,
      0,
      1.108906,
      0.925947,
      0.971558,
      NULL,
      NULL,
      3,
      NULL,
      1.875831,
      0,
      1,
      0,
      NULL,
      1,
      5.875528,
      0,
      0.084501,
      1.637881,
      0,
      2,
      1,
      NULL,
      1.985918,
      1,
      1.079079,
      5.462249,
      2.779648,
      1.515892,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      9.148242,
      1.331715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.626497,
      1.914131,
      1,
      1,
      NULL,
      0.531579,
      NULL,
      0.118030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.228967,
      NULL,
      NULL,
      NULL,
      NULL,
      1.308176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1.602467,
      NULL,
      NULL,
      NULL,
      0.824195,
      1,
      0.920466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.417999,
      NULL,
      0,
      NULL,
      0,
      2.153854,
      0.002510,
      0,
      0,
      0.982017,
      0,
      0,
      1.290828,
      NULL,
      0.131154,
      NULL,
      0,
      1.523955,
      0,
      0.886286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.428759,
      '44442',
      '',
      '',
      0,
      '',
      '',
      '',
      0.579857,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


