set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9136650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '001',
      '33244322',
      4.302506,
      31.872334,
      '3221121',
      163,
      0,
      3.041037,
      3,
      '301311',
      2.890835,
      ' 5-24-1984',
      9,
      6,
      0,
      NULL,
      1.953523,
      NULL,
      1,
      1,
      0,
      0.937844,
      3.758232,
      0,
      0,
      NULL,
      NULL,
      0,
      0.875370,
      NULL,
      1.286588,
      0,
      0.932332,
      0.597056,
      0,
      0,
      1.466234,
      0,
      0.974881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.002989,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.290688,
      NULL,
      1.479832,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.893408,
      1,
      0.092056,
      0,
      0,
      NULL,
      0.989631,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0.300240,
      NULL,
      NULL,
      3.824437,
      1,
      0,
      3,
      0.070733,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.381438,
      NULL,
      0.893509,
      NULL,
      0.261169,
      1,
      0.637205,
      5,
      0.302811,
      NULL,
      2,
      NULL,
      0.645050,
      1.713970,
      NULL,
      1.714859,
      NULL,
      NULL,
      3.354550,
      1.792319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.003503,
      NULL,
      1,
      0.474521,
      0.823966,
      1.720414,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      0.413518,
      NULL,
      NULL,
      4,
      0,
      0.052627,
      NULL,
      1.327400,
      0.273076,
      2,
      NULL,
      4,
      1.112110,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.634423,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.962837,
      0.863097,
      0.009282,
      0,
      NULL,
      0,
      1,
      3,
      0,
      1.373127,
      0.267417,
      NULL,
      0,
      1.144649,
      0,
      0.967656,
      1,
      0.008553,
      0.898372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.512695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.105257,
      '01341',
      '',
      '',
      0.635191,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      4.935857,
      NULL,
      1.023259,
      3.257878,
      0.184468,
      NULL,
      1,
      0.496494,
      1.866668);
commit;
end;
/


