set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517294';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-12-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      NULL,
      '1304300',
      1.447804,
      NULL,
      3.957142,
      NULL,
      NULL,
      1.904681,
      ' 6-14-1998',
      NULL,
      NULL,
      1.937209,
      NULL,
      1,
      NULL,
      0.769410,
      NULL,
      1.945793,
      NULL,
      3.581491,
      0,
      1.634414,
      1.014476,
      1.887149,
      0.105394,
      1,
      0.694406,
      1.961464,
      NULL,
      1.143205,
      NULL,
      1,
      0.048324,
      1.870794,
      1.380796,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.201847,
      1,
      0.379246,
      1.145979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.468592,
      1.944057,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.574132,
      1.946653,
      1,
      0.524472,
      NULL,
      0,
      0.539747,
      NULL,
      0.897398,
      NULL,
      0,
      0,
      0.863892,
      1,
      1,
      NULL,
      0,
      1.702072,
      0.045447,
      NULL,
      1,
      4.768408,
      1,
      0.326295,
      4.255139,
      NULL,
      4,
      NULL,
      NULL,
      2,
      3,
      5,
      1.633748,
      0.283508,
      5.731683,
      NULL,
      0,
      2,
      5.809144,
      3.866454,
      5.333321,
      NULL,
      NULL,
      2,
      4,
      5,
      6.093907,
      2,
      0.554229,
      NULL,
      NULL,
      0.494544,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.226274,
      0.240492,
      NULL,
      1,
      1,
      1.292723,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816393,
      NULL,
      NULL,
      NULL,
      NULL,
      1.742918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.028127,
      NULL,
      1.348197,
      NULL,
      NULL,
      NULL,
      1,
      2.093320,
      8.483631,
      2,
      0,
      1,
      1.045958,
      NULL,
      NULL,
      NULL,
      NULL,
      3.171120,
      1.160652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.196099,
      1.566287,
      0.873769,
      1,
      0.155708,
      3,
      2,
      NULL,
      1,
      2.267602,
      NULL,
      NULL,
      NULL,
      0.466262,
      1,
      NULL,
      0.306527,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.724186,
      NULL,
      '',
      '',
      0.435631,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


