set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9758171';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '310',
      '10120004',
      22.250605,
      NULL,
      '3320114',
      3.242561,
      1,
      2.633447,
      2,
      '203030',
      3.414084,
      ' 6-17-1978',
      NULL,
      10.209828,
      NULL,
      NULL,
      2.428844,
      1,
      1,
      1.017640,
      0,
      2,
      0.875751,
      1.524287,
      1.712858,
      0,
      1.039644,
      1,
      1,
      0,
      NULL,
      0.431507,
      1.123189,
      0,
      0.626202,
      1,
      0,
      NULL,
      1.719813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.280816,
      1,
      1.439910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.359726,
      2,
      1,
      1,
      0.434540,
      0.899299,
      NULL,
      NULL,
      0.345137,
      NULL,
      NULL,
      0.211349,
      1.436160,
      4.646039,
      NULL,
      1,
      1.746262,
      NULL,
      0,
      1,
      NULL,
      1.871915,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.875975,
      0,
      0.516991,
      NULL,
      1.900928,
      0,
      1.213238,
      NULL,
      1.224097,
      0.601263,
      4,
      0,
      0,
      0,
      0,
      1.099654,
      3,
      0.981184,
      4.153380,
      1,
      1.044007,
      0.370958,
      6,
      6.284193,
      6,
      NULL,
      2,
      4.033603,
      4.965080,
      2,
      1,
      0.697070,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.544094,
      0,
      NULL,
      1,
      NULL,
      0.887538,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.185877,
      NULL,
      NULL,
      4,
      6.221560,
      2,
      3,
      1,
      NULL,
      NULL,
      0,
      2.199497,
      0.533211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.285861,
      1.587236,
      NULL,
      NULL,
      2,
      3.982002,
      NULL,
      0,
      NULL,
      0.052596,
      1,
      1,
      NULL,
      1.520517,
      NULL,
      NULL,
      1,
      NULL,
      0.711409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '42212',
      NULL,
      NULL,
      1,
      '',
      NULL,
      NULL,
      1.729192,
      NULL,
      NULL,
      '',
      2,
      0.032200,
      5.778264,
      2,
      NULL,
      2,
      3,
      0,
      NULL);
commit;
end;
/


