set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614546';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1421',
      '13230132',
      44.742146,
      50.096381,
      '4244414',
      12,
      2,
      1.887163,
      NULL,
      '430131',
      2.699216,
      NULL,
      40,
      NULL,
      1.713275,
      NULL,
      1.058891,
      0.807989,
      1.326164,
      1,
      NULL,
      1,
      0,
      0.859434,
      3.065869,
      1.245539,
      NULL,
      0,
      1.064148,
      NULL,
      NULL,
      0.364405,
      NULL,
      NULL,
      0.181298,
      0,
      1.854990,
      0.949583,
      3.640908,
      NULL,
      0,
      1,
      0.541448,
      0.870033,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.896426,
      1,
      0.970999,
      1.040832,
      1.016774,
      NULL,
      NULL,
      1.035646,
      1.011925,
      NULL,
      NULL,
      NULL,
      3,
      1.632924,
      1.977132,
      1,
      1.843681,
      1.151436,
      1.205435,
      0,
      0.021575,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.989950,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.368919,
      0,
      1.726361,
      NULL,
      1,
      0,
      2.951791,
      0,
      NULL,
      0,
      1.473214,
      NULL,
      0,
      3.509894,
      0,
      1.056068,
      NULL,
      0.692344,
      1.114116,
      NULL,
      0.816741,
      1,
      0.500562,
      0.518915,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      4.916611,
      0,
      5,
      0,
      0,
      NULL,
      1.010143,
      3,
      NULL,
      NULL,
      4.911877,
      1.506838,
      0,
      1.437772,
      1.920022,
      1,
      1,
      NULL,
      1.831164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.910422,
      1,
      NULL,
      NULL,
      0,
      1,
      0.971521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.510732,
      NULL,
      NULL,
      NULL,
      NULL,
      1.320316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.658880,
      1,
      0.345184,
      NULL,
      3.012073,
      0.201613,
      NULL,
      5,
      1,
      2,
      1.309830,
      NULL,
      NULL,
      NULL,
      0.325066,
      3.803071,
      1.755844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      1,
      0,
      0,
      2,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0.595295,
      1.797488,
      NULL,
      0,
      0.367287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '21023',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      3,
      0.929484,
      1,
      1.763197);
commit;
end;
/


