set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614546';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      77.192834,
      3.666825,
      '3220324',
      2.427401,
      NULL,
      1,
      2,
      '420313',
      5,
      ' 6-10-1997',
      30.236790,
      8.705547,
      1.177470,
      NULL,
      1,
      0.154559,
      NULL,
      1.900653,
      NULL,
      0,
      0.783853,
      0.754460,
      NULL,
      0,
      4.346974,
      0.000457,
      1,
      0,
      0,
      1.755029,
      3,
      NULL,
      0,
      0.275974,
      0.596220,
      0.067253,
      4.688834,
      1,
      1.840650,
      0,
      0,
      0.788771,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.993374,
      1.309311,
      3.352584,
      0,
      1.608710,
      1,
      NULL,
      1.112177,
      NULL,
      1,
      2,
      1,
      1,
      0,
      0,
      0,
      2,
      1.932264,
      1,
      0.909931,
      0.689377,
      NULL,
      9,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.488890,
      NULL,
      NULL,
      1.889119,
      0,
      NULL,
      1.901054,
      0.174195,
      0.092165,
      2,
      0,
      0,
      1,
      4,
      NULL,
      0.082912,
      2.199327,
      0,
      1.847861,
      1,
      0,
      0,
      NULL,
      0.834496,
      1,
      0.195748,
      1.021203,
      1,
      1.937168,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.946401,
      1.236234,
      1,
      0.538507,
      2,
      1,
      0,
      4.385520,
      2,
      0.400031,
      0,
      4,
      5.590511,
      NULL,
      1.163429,
      1,
      NULL,
      1.685014,
      0.842460,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.583549,
      0.087917,
      0,
      0,
      1,
      0,
      1.542958,
      0.941743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187550,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.709848,
      0,
      1.469893,
      2,
      1.042137,
      1.296483,
      NULL,
      NULL,
      0.945465,
      5,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.448374,
      2.692095,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      0,
      3,
      1.600386,
      NULL,
      2,
      1,
      1.006498,
      0,
      1.556819,
      0,
      0.005412,
      NULL,
      1,
      1.840063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.346229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '33224',
      '',
      '',
      1.970094,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      NULL,
      4.616527,
      1.757864,
      NULL,
      3.625741,
      NULL,
      0.275675,
      1,
      0.611177,
      0.816458);
commit;
end;
/


